# encoding=utf-8
__author__ = "Aaron Randreth"
__copyright__ = "Copyright 2015+, Consortium MonPaGe"
__license__ = "Creative Commons 4.0 By-Nc-Sa"
__maintainer__ = "Roland Trouville"
__email__ = "contact.monpage@gmail.com"
__status__ = "Production"

from enum import Enum
from typing import Union, List


class Operation(Enum):
	"""
	Enum representing simple mathematical operations on a list of numeric values.

	Each member corresponds to an operation that takes a list of numbers
	and returns a single number as the result.

	Members:
	    SUM: Returns the sum of the values.
	    MEAN: Returns the mean (average) of the values.
	    DIFF: Returns the difference between the first and second values.
	    MAX: Returns the maximum value.

	Usage:
	    op = Operation.SUM
	    result = op([1, 2, 3])  # returns 6
	"""

	SUM = lambda values: sum(values)
	MEAN = lambda values: sum(values) / (len(values) * 1.0)
	DIFF = lambda values: values[0] - values[1]
	MAX = lambda values: max(values)

	def __call__(self, values: List[Union[float, int]]) -> Union[float, int]:
		return self.value(values)
