# encoding=utf-8

__author__ = "Roland Trouville"
__copyright__ = "Copyright 2015+, Consortium MonPaGe"
__license__ = "Creative Commons 4.0 By-Nc-Sa"
__maintainer__ = "Roland Trouville"
__email__ = "contact.monpage@gmail.com"
__status__ = "Production"

from cotation.acoustic.display.io_widget.float_input import FloatInput
from cotation.acoustic.display.io_widget.ui_line_with_input import UILineWithInput
from typing import Any, Callable, Optional

try:
	from typing import override
except ImportError:
	from typing_extensions import override  # noqa: F401

from cotation.acoustic.display.io_widget.info import InfoBox
from cotation.acoustic.display.io_widget.output import Output


# @property transparantly have getter and setter.
# class.x instead of class.(get,set)_x()

DEFAULT_SOUND_FILE_PATTERN = "{}_{}_Module{}.wav"


class F0Selection(InfoBox):
	min_f0_range: FloatInput
	max_f0_range: FloatInput

	min_f0: Output
	max_f0: Output

	min_f0_range_input: UILineWithInput
	max_f0_range_input: UILineWithInput

	_f0_min_changed_callback: Optional[Callable[[], Any]]
	_f0_max_changed_callback: Optional[Callable[[], Any]]

	_f0_min_or_max_changed_callback: Optional[Callable[[], Any]]

	def __init__(self):
		title = "Détection F0"
		paragraph = "Merci de vérifier que la F0 est correctement détectée."
		"Si nécessaire, ajuster légèrement les frontières gauche et droite,"
		"et/ou modifier le pitch range ci-dessous:"

		self.min_f0_range = FloatInput(False)
		self.max_f0_range = FloatInput(False)

		self.min_f0_range.setMinimum(0)
		self.max_f0_range.setMinimum(0)

		self.min_f0_range.setMaximum(1000)
		self.max_f0_range.setMaximum(1000)

		self.min_f0_range_input = UILineWithInput(
			"Min f0 range", "Hz", self.min_f0_range
		)
		self.max_f0_range_input = UILineWithInput(
			"Max f0 range", "Hz", self.max_f0_range
		)

		self.min_f0 = Output("Min F0", "Hz")
		self.max_f0 = Output("Max F0", "Hz")

		super().__init__(
			title,
			paragraph,
			[
				self.min_f0_range_input,
				self.max_f0_range_input,
				self.min_f0,
				self.max_f0,
			],
		)

	def set_f0_min_or_max_changed_callback(self, callback: Callable[[], Any]) -> None:
		"""
		Sets a callback function to be called whenever the minimum or maximum F0 range value changes.

		Args:
			callback (Callable[[], Any]): The function to be called on F0 min or max value changes.
		"""

		self._f0_min_or_max_changed_callback = callback
		self.min_f0_range.set_value_changed_data_callback(
			self._f0_min_or_max_changed_callback
		)
		self.max_f0_range.set_value_changed_data_callback(
			self._f0_min_or_max_changed_callback
		)
