from cotation.acoustic.struct.pm.parselmouth_sound import ParselmouthSound
from cotation.acoustic.struct.pm.parselmouth_spectrogram import ParselmouthSpectrogram
import numpy
import parselmouth


class ParselmouthAudioFile:
	"""
	Objet that determine a Parselmouth thanks to caracteristic
	"""

	__sound_data: parselmouth.Sound

	def __init__(self, filepath: str):
		self.__sound_data = parselmouth.Sound(filepath)

	def get_sound(self) -> ParselmouthSound:
		"""
		Return sound object of Parselmouth
		:return Sound:
		"""
		return ParselmouthSound(self.__sound_data.xs(), self.__sound_data.values)
		# return Sound(self.__sound_data.xs(), self.__sound_data.values[0])

	def get_spectrogram(self):
		"""
		Return spectrogram object of Parselmouth
		:return spectrogram:
		"""
		spectrogram = self.__sound_data.to_spectrogram()
		linear_values = 10 * numpy.log10(spectrogram.values)

		spect = ParselmouthSpectrogram(
			spectrogram.x_grid(), spectrogram.y_grid(), linear_values
		)

		return spect

	def get_duration(self):
		"""
		Calculates and returns the duration of the sound data in seconds.

		Returns:
			float: Duration computed as the number of samples divided by the sampling frequency.
		"""

		return self.__sound_data.n_samples / self.__sound_data.sampling_frequency * 1.0
