##########################################################################################################
## This script opens all sound files and matching TextGrids in a directory, pair by pair, alows making
## changes to the TextGrid and saving it before moving to the next pair of files.
## Once all file pairs have been annotated it calculates durations of non-empty intervals, week duration
## from one mercredi to the next mercredi, and from one jeudi to the next jeudi, as well as speech rate
## and articulation rate over mercredi jeudi pair.
##
## The script was written for analyzing data for project MonPaGe. May 2016.
## Revised in September 2016
##########################################################################################################

# Create a dialog box and enter the directory location with the sound files and the type of sound files.

form Enter directory
# Enter full path to the directory where the recordings are stored
# IMPORTANT: Insert a SLASH AT THE END of the directory name!!!(backslash \ for Windows, forward slash / for Mac)
	sentence IMPORTANT_READ Insert \ (for Windows) or / (for Mac) at the end of directory name.
	sentence Directory
	sentence Filetype wav
	sentence Resultfile Results_DoubleTache_Simple
endform

############################################################################
## This part of the script gives user a hand to make changes to annotations.
# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings
for i from 1 to numberOfFiles

	# Select the first filename from the list.  
	select Strings fileList
	soundFile$ = Get string... i
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Open a matching Textgrid file
	Read from file... 'directory$''fileName$'.Textgrid

	# Select sound object together with textgrid and open them.
	# The script will pause once a sound and textgrid files are opened. Modify annotations.
	# Click CONTINUE to move to the next sound-textgrid pair.
	select TextGrid 'fileName$'
	plus Sound 'fileName$'
	Edit
	pause  Insert boundaries and annotations. 

	# Modified TextGrid is saved with the same filename and in the same directory as the original TextGrid.
	minus Sound 'fileName$'
	Write to text file... 'directory$''fileName$'.TextGrid

	# End the loop for the selected file and go on to the next file.
	select all
	minus Strings fileList
	Remove

endfor

# Clean up the Praat objects window.
select Strings fileList
Remove

#################################################################################
## This part of the script performs sound file analysis and extracts the measures.
# Create results file and the header for the columns
fileappend "'directory$''resultfile$'.txt" Speaker'tab$'Sex'tab$'Langauge'tab$'FileName'tab$'Module'tab$'TierName'tab$'Label'tab$'Word'tab$'Comment'tab$'Start'tab$'End'tab$'Duration'tab$'SpeechRate'tab$'ArticulationRate'newline$'

# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings
for n from 1 to numberOfFiles

	# Start by selecting the first file from the list and go through the list.  
	select Strings fileList
	soundFile$ = Get string: n
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Open a matching textgrid file
	Read from file... 'directory$''fileName$'.TextGrid
	select TextGrid 'fileName$'

	module$ = "Semaine"


	# Get measures of each interval on each tier
	numberOfTiers = Get number of tiers

	for t to numberOfTiers-1
	 	tierName$ = Get tier name: t
		numberOfIntervals = Get number of intervals: t
########################################################################		
		for j to numberOfIntervals
			intervalLabel$ = Get label of interval: t, j
			flag = 0
			if tierName$ = "IntervalStart"	
				if ( (intervalLabel$ <> "") and (intervalLabel$ <> "#") )
					intervalStart = Get starting point: t, j
					intervalEnd = Get end point: t, j
					intervalDuration = intervalEnd - intervalStart
					intervalLabel = number (intervalLabel$)
					weekRate = intervalLabel / intervalDuration
					flag = 1
				endif
			elsif tierName$ = "TwoDaysStart"
				if ( (intervalLabel$ <> "") and (intervalLabel$ <> "#") )
					intervalStart = Get starting point: t, j
					intervalEnd = Get end point: t, j
					intervalDuration = intervalEnd - intervalStart
					twoDaysSyllableRate = 5 / intervalDuration
					flag = 2
				endif
			elsif tierName$ = "IntervalEnd"
				if ( (intervalLabel$ <> "") and (intervalLabel$ <> "#") )
					intervalStart = Get starting point: t, j
					intervalEnd = Get end point: t, j
					intervalDuration = intervalEnd - intervalStart
					intervalLabel = number (intervalLabel$)
					weekRate = intervalLabel / intervalDuration
					flag = 1
				endif
			elsif tierName$ = "TwoDaysEnd"
				if ( (intervalLabel$ <> "") and (intervalLabel$ <> "#") )
					intervalStart = Get starting point: t, j
					intervalEnd = Get end point: t, j
					intervalDuration = intervalEnd - intervalStart
					twoDaysSyllableRate = 5 / intervalDuration
					flag = 2
				endif
			endif

#########################################################

				#Check if there is a comment in a Comments tier for any of the annotated intervals on other tiers.
				numberOfIntervalsComments = Get number of intervals: numberOfTiers
				
				comment$ = ""

				for c to numberOfIntervalsComments
					intervalCommentLabel$ = Get label of interval: numberOfTiers, c
				
					if intervalCommentLabel$ <> ""
						intervalStartComments = Get starting point: numberOfTiers, c
						intervalEndComments = Get end point: numberOfTiers, c

						if not (  (intervalEndComments < intervalStart) or (intervalStartComments > intervalEnd)  )
							comment$ = comment$ + " " + intervalCommentLabel$
						endif


					endif
				endfor
				if flag = 1
				fileappend "'directory$''resultfile$'.txt" 'tab$''tab$''tab$''fileName$''tab$''module$''tab$''tierName$''tab$''intervalLabel$''tab$''comment$''tab$''intervalStart:3''tab$''intervalEnd:3''tab$''intervalDuration:3''tab$''weekRate:3''tab$''newline$'
			elsif flag = 2
				fileappend "'directory$''resultfile$'.txt" 'tab$''tab$''tab$''fileName$''tab$''module$''tab$''tierName$''tab$''intervalLabel$''tab$''comment$''tab$''intervalStart:3''tab$''intervalEnd:3''tab$''intervalDuration:3''tab$''tab$''twoDaysSyllableRate:3''newline$'
			endif
		endfor
	endfor
endfor
			

# Clean up the Praat objects window.
select all
Remove
