#!/bin/bash
# -*- coding: UTF-8 -*-
# Base sur le fichier command de sppas http://www.sppas.org/
# Par Brigitte Bigi
#
# Fix the locale with a generic value!
LANG='C'

# Program infos
PROGRAM_DIR=$(cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd)

# ===========================================================================
# MAIN
# ===========================================================================
export PYTHONIOENCODING=UTF-8

PYTHON=""
v="0"

echo -n "Recherche de la commande 'python3' pour Python: "
for cmd in `which -a python3`;
do
    v=$($cmd -c "import sys; print(sys.version_info[0])");
    if [[ "$v" == "3" ]]; then
        PYTHON=$cmd;
        break;
    fi;
done

if [ -z "$PYTHON" ]; then
    echo "introuvable."
    echo -n "Recherche de la commande 'python' pour Python 3: "
    for cmd in `which -a python`;
    do
        v=$($cmd -c "import sys; print(sys.version_info[0])");
        if [[ "$v" == "3" ]]; then
            PYTHON=$cmd;
            break;
        fi;
    done
else
    echo "OK";
fi

echo;

if [ -z "$PYTHON" ]; then
    echo "introuvable.";
    echo "Python n'a pas l'air d'etre sur votre systeme d'exploitation.";
    echo "Commencez par l'installer http://www.python.org. Ensuite reessayez de lancer monpage.";
    exit -1;
fi

ENV_DIR=venv
if [ ! -d "$ENV_DIR" ]; then
    echo "Creation de l'environnement virtuel..."
	python3 -m venv $ENV_DIR
fi
source ./$ENV_DIR/bin/activate

# Get the name of the system
unamestr=`uname | cut -f1 -d'_'`;
SQLITE_VERSION=$($PYTHON -c "import sqlite3; print(sqlite3.connect(':memory:').execute('select sqlite_version();').fetchone()[0], end='')")

echo "Monpage va se lancer avec les parametres: ";
echo "  - Commande: '$PYTHON' (version $v)";
echo "  - SQLITE: $SQLITE_VERSION";
echo "  - Systeme:  $unamestr";
echo "  - Affichage:  $DISPLAY";
echo "  - Chemin: $PROGRAM_DIR";
echo "  - Environnement virtuel: $ENV_DIR";
echo "Lancement de l'application graphique...";

cd "$PROGRAM_DIR"
python3 main.py
