# encoding=utf-8

__author__ = "Roland Trouville"
__copyright__ = "Copyright 2015+, Consortium MonPaGe"
__license__ = "Creative Commons 4.0 By-Nc-Sa"
__maintainer__ = "Roland Trouville"
__email__ = "contact.monpage@gmail.com"
__status__ = "Production"

try:
	from typing import override
except ImportError:
	from typing_extensions import override  # noqa: F401

from cotation.acoustic.display.io_widget.info import InfoBox
from cotation.acoustic.display.io_widget.output import Output


# @property transparantly have getter and setter.
# class.x instead of class.(get,set)_x()

DEFAULT_SOUND_FILE_PATTERN = "{}_{}_Module{}.wav"


class F0Prerequisits(InfoBox):
	voice_breaks: Output
	signal_to_noise_ratio: Output

	def __init__(self):
		title = "Qualité de l'enregistrement"
		paragraph = "La qualité des calculs peut être impacté si : les ruptures de voisement dépassent les 15 %, ou le ratio signal-bruit est inférieur à 40."
		paragraph += (
			"\n\n"
			+ "Les calculs sont inutilisables, et ne seront pas pris en compte si : les ruptures de voisement dépassent les 25 %, ou le ratio signal-bruit est inférieur à 30."
		)

		self.voice_breaks = Output(
			"Ruptures de voisement (inclut une éventuelle pause)", "%"
		)
		self.signal_to_noise_ratio = Output("Ratio signal-bruit", "")

		super().__init__(
			title,
			paragraph,
			[self.voice_breaks, self.signal_to_noise_ratio],
		)
