# encoding=utf-8
"""
File for the CotationTexteWindow class
"""

from cotation.cotation_window import CotationWindow
from passation.module_intelligibilite_window import ModuleIntelligibiliteWindow
from tools.csv_manager import CSVManager

__author__ = "Roland Trouville"
__copyright__ = "Copyright 2015+, Consortium MonPaGe"
__license__ = "Creative Commons 4.0 By-Nc-Sa"
__maintainer__ = "Roland Trouville"
__email__ = "contact.monpage@gmail.com"
__status__ = "Production"

import os

from PySide6.QtCore import Qt
from PySide6.QtWidgets import QGroupBox, QLabel, QPushButton, QRadioButton

from tools.display_tools import DisplayTools


class CotationIntelligibiliteWindow(CotationWindow):
	background = None
	data = None
	positions_to_xy = []

	# module_name = None
	# judge_code = None
	# directory_path = None
	# session_path = None
	participant_code = None
	# advanced_mode = None

	def __init__(
		self,
		parent,
		participant_code,
		module_name,
		judge_code,
		session_path,
		advanced_mode=False,
	):
		super().__init__(participant_code, parent)
		self.module_name = module_name
		self.judge_code = judge_code
		self.session_path = session_path
		self.directory_path = (
			"./data/participant/" + participant_code + "/" + session_path
		)
		self.advanced_mode = advanced_mode

		self.init_cotation()
		self.init_participant_result_db()
		self.current_file_index = 0
		self.load_script()
		self.init_ui()
		self.display_cotation()

	def init_ui(self):
		"""
		Initialize the UI
		:return: None
		"""
		super().init_ui()

		self.background = QLabel(self)
		self.background.resize(DisplayTools.size(800, 540))
		self.background.move(DisplayTools.coord(0, 0))
		self.background.setAlignment(Qt.AlignmentFlag.AlignCenter)

		DisplayTools.display_image(
			self.background, "./data/module/ModuleIntelligibilite/fond.png"
		)

		tmp = QLabel(self)
		tmp.resize(DisplayTools.size(60, 60))
		self.positions_to_xy = DisplayTools.calculate_positions_xy(
			self.background,
			tmp,
			ModuleIntelligibiliteWindow.lines,
			ModuleIntelligibiliteWindow.cols,
		)

		tmp = QPushButton("Enregistrer", self)
		tmp.move(DisplayTools.coord(640, 545))
		tmp.resize(DisplayTools.size(120, 30))
		# DisplayTools.set_font_size(tmp, "lab_ctn_save")
		tmp.clicked.connect(self.save)

		tmp = QLabel(
			"1 pt = Vous avez une seule réponse et celle-ci est correcte.\n1/2 pt = Vous avez 2 réponses et l'une "
			"d'entre elles est correcte.\n0 pt = mot non reconnu",
			self,
		)
		tmp.move(DisplayTools.coord(35, 545))
		tmp.resize(DisplayTools.size(600, 40))
		DisplayTools.set_font_size(tmp, "cotation_intell_cons", True, None)

	def init_cotation(self):
		"""
		Initialize the cotation.
		:return: None
		"""
		super().init_cotation()

	def init_participant_result_db(self):
		"""
		Initialize the participant specific cotation database
		:return: None
		"""
		super().init_participant_result_db()

	# noinspection PyArgumentList
	def display_cotation(self):
		"""
		Set the display of cotation.
		:returns None
		"""
		for dat in self.data:
			tmp = QLabel(self)
			tmp.resize(60, 60)
			tmp.setAlignment(Qt.AlignmentFlag.AlignCenter)

			tmp2 = QLabel(self)
			tmp2.resize(60, 30)
			tmp2.setAlignment(Qt.AlignmentFlag.AlignCenter)
			tmp2.setAutoFillBackground(True)

			tmp2.setText(dat[0])
			pos = (int(dat[1]), int(dat[2]))

			DisplayTools.display_image(
				tmp, "./data/module/ModuleIntelligibilite/images/" + dat[0] + ".png"
			)
			tmp.show()
			tmp.move(
				self.positions_to_xy[pos][0] - 15, self.positions_to_xy[pos][1] - 10
			)
			tmp.setVisible(True)
			tmp.raise_()
			tmp2.show()
			tmp2.move(
				self.positions_to_xy[pos][0] - 15, self.positions_to_xy[pos][1] + 50
			)
			DisplayTools.set_font_size(tmp2, None, False, 15)
			tmp2.setVisible(True)
			tmp2.raise_()

			score = self.get_stored_score(
				self.session_path, self.participant_code, self.judge_code, dat[0]
			)
			if score is None:
				score = 1

			tmpgroup = QGroupBox("score", self)
			tmpgroup.setObjectName(dat[0])
			tmpgroup.resize(45, 90)
			tmpgroup.move(
				self.positions_to_xy[pos][0] + 45, self.positions_to_xy[pos][1] - 10
			)

			tmpradio = QRadioButton("0", tmpgroup)
			tmpradio.setObjectName("0")
			tmpradio.setChecked(score == 0)
			tmpradio.move(2, 12)

			tmpradio = QRadioButton("1/2", tmpgroup)
			tmpradio.setObjectName("0.5")
			tmpradio.setChecked(score == 0.5)
			tmpradio.move(2, 32)

			tmpradio = QRadioButton("1", tmpgroup)
			tmpradio.setObjectName("1")
			tmpradio.setChecked(score == 1)
			tmpradio.move(2, 52)

			tmpradio = QRadioButton("N/A", tmpgroup)
			tmpradio.setObjectName("-1")
			tmpradio.setChecked(score == -1)
			tmpradio.move(2, 72)

			tmpgroup.setAutoFillBackground(True)

	def load_script(self):
		"""
		Load scripts of cotation
		:returns None
		"""
		filename = None
		if os.path.isdir(self.directory_path):
			for fn in os.listdir(self.directory_path):
				if fn.endswith("script.csv"):
					filename = fn

		if filename is None:
			raise Exception("Fichier de script introuvable pour cette session")

		self.data = CSVManager.read_file(self.directory_path + "/" + filename)

	def save(self):
		"""
		Set format and Save data cotation.
		:returns None
		"""

		tosave = []
		word_order = 1
		for child in self.children():
			if type(child) is QGroupBox:
				word = str(child.objectName())
				score = "0"
				for child2 in child.children():
					if type(child2) is QRadioButton:
						if child2.isChecked():
							score = str(child2.objectName())

				score = float(score)
				tosave.append((word, score, word_order))
				word_order += 1

		if len(tosave) > 0:
			for couple in tosave:
				self.set_stored_score(
					self.session_path,
					self.participant_code,
					self.judge_code,
					couple[0],
					couple[1],
					couple[2],
				)
		super().end_cotation()
