##########################################################################################################
## This script opens all sound files in a directory, one by one, checks if a TextGrid with the same name 
## already exists. If it doesn't, it creates a TextGrid with specified tier names, opens sound file and
## TextGrid together into the editor where boundaries and annotations can be added.
## After manually inserting a boundary at the beginning of an utterance on tier Syllable another boundary
## is automatically inserted at the following time point: start boundary + specified target interval duration.
##
## The script was written for analyzing data for project MonPaGe. 
## Revised in September 2016
##########################################################################################################

# Create a dialog box and enter the directory location with the sound files, the type of sound files and
# the name of the textgrid tier(s).

form Enter directory
# Enter full path to the directory where the recordings are stored
# IMPORTANT: Insert a SLASH AT THE END of the directory name!!!(backslash \ for Windows, forward slash / for Mac)
# IMPORTANT: Textgrid tier names have to be enclosed in " ".
# Enter duration of the target interval.
	sentence IMPORTANT_READ Insert \ (for Windows) or / (for Mac) at the end of directory name.
	sentence Directory 
	sentence Filetype wav
	sentence TierName "Syllable Comments"
	sentence Target_Interval_Duration 4
endform

#########################################################################################################
##  This part of the script creates textgrids and allows the user to insert a boundary.
# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings

for i from 1 to numberOfFiles

	# Select the first filename from the list.  
	select Strings fileList
	soundFile$ = Get string... i
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Check if TextGrid exists for the file
	textgrid_name$ = directory$ + fileName$ + ".TextGrid"
	if fileReadable (textgrid_name$)

	else
		# Create a TextGrid for the selected sound file.
		To TextGrid... 'TierName$'

		# Select sound object together with textgrid and open.
		# The script will pause once a sound and tegrid files are opened. Insert boundaries and annotations.
		# Click CONTINUE to move to the next sound-textgrid pair.
		plus Sound 'fileName$'
		Edit
		pause  Insert boundaries and annotations. 

		# TextGrid is saved with the same filename and in the same directory as the sound files.
		minus Sound 'fileName$'
		Write to text file... 'directory$''fileName$'.TextGrid

		# End the loop for the selected file and go on to the next file.
	endif
	select all
	minus Strings fileList
	Remove

endfor

#########################################################################################################
##  This part of the script inserts the final boundary in order to create an interval of target duration.
# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings

for i from 1 to numberOfFiles

	# Select the first filename from the list.  
	select Strings fileList
	soundFile$ = Get string... i
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Open a matching textgrid file
	Read from file... 'directory$''fileName$'.TextGrid
	select TextGrid 'fileName$'

	#Insert boundaries at a set time from start and before the end of the annotated interval.

	annInterval_1 = Get number of intervals: 1
	annStart = Get starting point: 1, annInterval_1
	firstInterval = annStart + 'Target_Interval_Duration$'
	Insert boundary: 1, firstInterval

	# TextGrid is saved with the same filename and in the same directory as the sound files.
	Write to text file... 'directory$''fileName$'.TextGrid

	# End the loop for the selected file and go on to the next file.
	select all
	minus Strings fileList
	Remove
endfor

# Clean up the Praat objects window.
select all
Remove