##########################################################################################################
## This script opens all sound files and matching TextGrids in a directory, pair by pair, alows making
## changes to the TextGrid and saving it before moving to the next pair of files.
## Once all file pairs have been annotated it calculates durations of non-empty intervals, week duration
## from one mercredi to the next mercredi, and from one jeudi to the next jeudi, as well as speech rate
## and articulation rate over mercredi jeudi pair.
##
## The script was written for analyzing data for project MonPaGe. May 2016.
## Revised in September 2016
##########################################################################################################

# Create a dialog box and enter the directory location with the sound files and the type of sound files.

form Enter directory
# Enter full path to the directory where the recordings are stored
# IMPORTANT: Insert a SLASH AT THE END of the directory name!!!(backslash \ for Windows, forward slash / for Mac)
	sentence IMPORTANT_READ Insert \ (for Windows) or / (for Mac) at the end of directory name.
	sentence Directory
	sentence Filetype wav
	sentence Resultfile Results_SpeechRate_Semaine
endform

############################################################################
## This part of the script gives user a hand to make changes to annotations.
# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings
for i from 1 to numberOfFiles

	# Select the first filename from the list.  
	select Strings fileList
	soundFile$ = Get string... i
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Open a matching Textgrid file
	Read from file... 'directory$''fileName$'.Textgrid

	# Select sound object together with textgrid and open them.
	# The script will pause once a sound and textgrid files are opened. Modify annotations.
	# Click CONTINUE to move to the next sound-textgrid pair.
	select TextGrid 'fileName$'
	plus Sound 'fileName$'
	Edit
	pause  Insert boundaries and annotations. 

	# Modified TextGrid is saved with the same filename and in the same directory as the original TextGrid.
	minus Sound 'fileName$'
	Write to text file... 'directory$''fileName$'.TextGrid

	# End the loop for the selected file and go on to the next file.
	select all
	minus Strings fileList
	Remove

endfor

# Clean up the Praat objects window.
select Strings fileList
Remove

#################################################################################
## This part of the script performs sound file analysis and extracts the measures.
# Create results file and the header for the columns
fileappend "'directory$''resultfile$'.txt" Speaker'tab$'Sex'tab$'Langauge'tab$'FileName'tab$'Module'tab$'TierName'tab$'Label'tab$'Word'tab$'Comment'tab$'Start'tab$'End'tab$'Duration'tab$'SpeechRate'tab$'ArticulationRate'newline$'

# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings
for n from 1 to numberOfFiles

	# Start by selecting the first file from the list and go through the list.  
	select Strings fileList
	soundFile$ = Get string: n
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Open a matching textgrid file
	Read from file... 'directory$''fileName$'.TextGrid
	select TextGrid 'fileName$'

	module$ = "Semaine"


	# Get measures of each interval on each tier
	numberOfTiers = Get number of tiers

	for t to numberOfTiers-1
	 	tierName$ = Get tier name: t
		numberOfIntervals = Get number of intervals: t
		
		# Reset variables
		numberLabeledIntervals = 0
		sumIntervalDuration = 0
		numberLabeledIntervalsNoPauses = 0
		sumIntervalDurationNoPauses = 0
		beginningOfLastMercredi = 0
		beginningOfLastJeudi = 0
		jeudiFlag = 0
		sumPausesSinceLastMercredi = 0
		numberOfNonPauseIntervalsSinceLastMercredi = 0
		missingSyllable= 0

		# Measure interval duration of each labeled interval, and get sum of all labeled intervals.
		for j to numberOfIntervals
			intervalLabel$ = Get label of interval: t, j

			word$ = ""

			if intervalLabel$ <> ""
				intervalStart = Get starting point: t, j
				intervalEnd = Get end point: t, j
				intervalDuration = intervalEnd - intervalStart
				numberLabeledIntervals = numberLabeledIntervals + 1
				sumIntervalDuration = sumIntervalDuration + intervalDuration

			
				# Calculate duration from the beginning of one 'mercredi' to the beginning of the next 'mercredi'. 
				weekDurationMercredi = 0
				if (intervalLabel$ = "mer") or (intervalLabel$ = "mer&")
					jeudiFlag = 0
					missingSyllable= 0
					sumPausesSinceLastMercredi = 0
					numberOfNonPauseIntervalsSinceLastMercredi =0

					if beginningOfLastMercredi = 0
						beginningOfLastMercredi = intervalStart
					else
						weekDurationMercredi = intervalStart - beginningOfLastMercredi
						beginningOfLastMercredi = intervalStart
					endif
				endif

				if (intervalLabel$ = "mer&") or (intervalLabel$ = "jeu&") or (intervalLabel$ = "di&") or (intervalLabel$ = "cre&")
					missingSyllable= 1
				endif


				# Get sum of all labeled intervals excpet pauses (marked with #).
				if intervalLabel$ <> "#"
					numberLabeledIntervalsNoPauses = numberLabeledIntervalsNoPauses + 1
					sumIntervalDurationNoPauses = sumIntervalDurationNoPauses + intervalDuration
					numberOfNonPauseIntervalsSinceLastMercredi = numberOfNonPauseIntervalsSinceLastMercredi + 1
				endif



				# Calculate duration from the beginning of one 'mercredi' to the end of the following 'jeudi'.
				twoDaysDuration = 0
				twoDaysDurationNoPauses = 0
				if (intervalLabel$ = "di") and (jeudiFlag = 1)
					twoDaysDuration = intervalEnd - beginningOfLastMercredi
					twoDaysDurationNoPauses = twoDaysDuration - sumPausesSinceLastMercredi
				endif

				# Calculate duration from the beginning of one 'jeudi' to the beginning of the next 'jeudi'.
				weekDurationJeudi = 0
				if (intervalLabel$ = "jeu") or (intervalLabel$ = "jeu&")
					jeudiFlag = 1
					if beginningOfLastJeudi = 0
						beginningOfLastJeudi = intervalStart
					else
						weekDurationJeudi = intervalStart - beginningOfLastJeudi
						beginningOfLastJeudi = intervalStart
					endif
				endif

				if (intervalLabel$ = "mer") or (intervalLabel$ = "cre") or (intervalLabel$ = "mer&") or (intervalLabel$ = "cre&")
					word$ = "mercredi"
				elsif (intervalLabel$ = "jeu") or (intervalLabel$ = "jeu&")
					word$ = "jeudi"
				elsif ((intervalLabel$ = "di") or (intervalLabel$ = "di&")) and jeudiFlag = 0
					word$ = "mercredi"
				elsif ((intervalLabel$ = "di") or (intervalLabel$ = "di&")) and jeudiFlag = 1
					word$ = "jeudi"
				endif


				# Calculate duration of pauses between two 'mercredi's.
				if intervalLabel$ = "#"
					sumPausesSinceLastMercredi = sumPausesSinceLastMercredi + intervalDuration
				endif

				#Check if there is a comment in a Comments tier for any of the annotated intervals on other tiers.
				numberOfIntervalsComments = Get number of intervals: numberOfTiers
				
				comment$ = ""

				for c to numberOfIntervalsComments
					intervalCommentLabel$ = Get label of interval: numberOfTiers, c
				
					if intervalCommentLabel$ <> ""
						intervalStartComments = Get starting point: numberOfTiers, c
						intervalEndComments = Get end point: numberOfTiers, c

						if not (  (intervalEndComments < intervalStart) or (intervalStartComments > intervalEnd)  )
							comment$ = comment$ + " " + intervalCommentLabel$
						endif


					endif
				endfor
				fileappend "'directory$''resultfile$'.txt" 'tab$''tab$''tab$''tab$''tab$''tab$''fileName$''tab$''module$''tab$''tierName$''tab$''intervalLabel$''tab$''word$''tab$''comment$''tab$''intervalStart:3''tab$''intervalEnd:3''tab$''intervalDuration:3''newline$'

				if weekDurationMercredi <> 0
					fileappend "'directory$''resultfile$'.txt" 'tab$''tab$''tab$''tab$''tab$''tab$''fileName$''tab$''module$''tab$''tierName$''tab$'mercredi-mercredi'tab$''tab$''comment$''tab$''tab$''tab$''weekDurationMercredi:3''newline$'
				endif

				if weekDurationJeudi <> 0
					fileappend "'directory$''resultfile$'.txt" 'tab$''tab$''tab$''tab$''tab$''tab$''fileName$''tab$''module$''tab$''tierName$''tab$'jeudi-jeudi'tab$''tab$''comment$''tab$''tab$''tab$''weekDurationJeudi:3''newline$'
				endif

				# Calculate speech and articulation rate over 'mercredi & jeudi'. Write to result file.
				if (twoDaysDuration <> 0) and (missingSyllable = 0)
					twoDaysSpeechRate = numberOfNonPauseIntervalsSinceLastMercredi / twoDaysDuration
					twoDaysArticulationRate = numberOfNonPauseIntervalsSinceLastMercredi / twoDaysDurationNoPauses
					fileappend "'directory$''resultfile$'.txt" 'tab$''tab$''tab$''tab$''tab$''tab$''fileName$''tab$''module$''tab$''tierName$''tab$'mercredi&jeudi'tab$''tab$''comment$''tab$''beginningOfLastMercredi:3''tab$''tab$''tab$''twoDaysSpeechRate:3''tab$''twoDaysArticulationRate:3''newline$'
				endif

			endif
		endfor
	endfor
endfor

# Clean up the Praat objects window.
select all
Remove

