##############################################################################################################
## This script opens all sounds files in a directory, one by one, checks if a TextGrid with the same name 
## already exists. If it doesn't, it creates a TextGrid with specified tier names, automatically inserts the
## correct number of intervals and their labels,  opens sound file and TextGrid together into the editor where 
## boundaries of the interval have to be adjusted to audio signal.
## Once it goes through all the files in the directory, it measures duration of the annotated intervals
## on each of the tiers in all TextGrind files and writes the measures into a result file.
##
## The script uses procedure split written by Atria (2014)
## The script was written for analyzing data for project MonPaGe. May 2016.
## Revised in September 2016
##############################################################################################################

# Create a dialog box and enter the directory location with the sound files, the type of sound files and
# the name of the textgrid tier(s).
form Enter directory
# Enter full path to the directory where the recordings are stored
# IMPORTANT: Insert a SLASH AT THE END of the directory name!!!(backslash \ for Windows, forward slash / for Mac)
# IMPORTANT: Textgrid tier names have to be enclosed in " ".
	sentence IMPORTANT_READ Insert \ (for Windows) or / (for Mac) at the end of directory name.
	sentence Directory 
	sentence Filetype wav
	sentence TierName "VCInterval Comments"
	sentence Resultfile Results_SpeechRate_Text
endform

#####################################################################################################################
## This part of the script creates textgrids, inserts all the necessary boundaries and labels the relevant intervals.

# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings

for i from 1 to numberOfFiles

	# Select the first filename from the list.  
	select Strings fileList
	soundFile$ = Get string... i
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")
	
	# Get total duration of the sound file
	totalDuration = Get total duration

	# Check if TextGrid exists for the file
	textgrid_name$ = directory$ + fileName$ + ".TextGrid"
	if fileReadable (textgrid_name$)
	else

		# Create a TextGrid for the selected sound file.
		To TextGrid... 'TierName$'

		#Insert boundaries at a set time from start and before the end of the annotated interval.
		Insert boundary: 1, totalDuration - 1.400
		Set interval text: 1, 2, "e"
		Insert boundary: 1, totalDuration - 1.200
		Set interval text: 1, 3, "o"
		Insert boundary: 1, totalDuration - 1.000
		Set interval text: 1, 4, "1"
		Insert boundary: 1, totalDuration - 0.800
		Set interval text: 1, 5, "o~"
		Insert boundary: 1, totalDuration - 0.600
		Set interval text: 1, 6, "u"
		Insert boundary: 1, totalDuration - 0.400
		Set interval text: 1, 7, "o~f"
		Insert boundary: 1, totalDuration - 0.200

		# TextGrid is saved with the same filename and in the same directory as the sound files.
		minus Sound 'fileName$'
		Write to text file... 'directory$''fileName$'.TextGrid

	# End the loop for the selected file and go on to the next file.
	endif
	select all
	minus Strings fileList
	Remove
endfor

############################################################################
## This part of the script gives user a hand to make changes to annotations.
# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings

for i from 1 to numberOfFiles

	# Select the first filename from the list.  
	select Strings fileList
	soundFile$ = Get string... i
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Open a matching textgrid file
	Read from file... 'directory$''fileName$'.TextGrid
	select TextGrid 'fileName$'

	# Select sound object together with textgrid and open.
	# The script will pause once a sound and tegrid files are opened. Insert boundaries and annotations.
	# Click CONTINUE to move to the next sound-textgrid pair.
	plus Sound 'fileName$'
	Edit
	pause  Insert boundaries and annotations. 

	# TextGrid is saved with the same filename and in the same directory as the sound files.
	minus Sound 'fileName$'
	Write to text file... 'directory$''fileName$'.TextGrid

	select all
	minus Strings fileList
	Remove
endfor

##################################################################################
## This part of the script performs sound file analysis and extracts the measures.
# Create results file and the header for the columns
fileappend "'directory$''resultfile$'.txt" Speaker'tab$'Sex'tab$'Langauge'tab$'FileName'tab$'Module'tab$'Task'tab$'TierName'tab$'Label'tab$'Comment'tab$'Start'tab$'End'tab$'Duration'tab$'VCI_SpeechRate'tab$'VCI_MeanDuration'newline$'

# Make a list of all sound files in the directory.
Create Strings as file list... fileList 'directory$'*.'filetype$'

# Loop through all files.
numberOfFiles = Get number of strings
for n from 1 to numberOfFiles

	# Start by selecting the first file from the list and go through the list.  
	select Strings fileList
	soundFile$ = Get string: n
	Read from file... 'directory$''soundFile$'

	# A variable called "fileName$" gets the same name as the sound file.
	fileName$ = selected$ ("Sound")

	# Open a matching textgrid file
	Read from file... 'directory$''fileName$'.TextGrid
	select TextGrid 'fileName$'

	# Call a procedure @split from a praat script positioned at the end of this file.

	@split ("_", fileName$)
	for s to split.length
		str$[s] = split.array$[s]
	endfor

######################### Parametrage en fonction du nom du fichier ###########
	speaker$ = ""
	sex$ = ""
	language$ = ""
	module$ = "module"
	task$ = "stimuli"

	if split.length == 8
		speaker$ = split.array$[3]
		sex$ = split.array$[2]
		language$ = split.array$[1]
		module$ = split.array$[7]
		task$ = split.array$[8]

	elsif split.length == 6
		speaker$ = split.array$[1]
		module$ = split.array$[5]
		task$ = split.array$[6]

	endif


########################################################################

	# Get measures of each interval on each tier
	numberOfTiers = Get number of tiers
	for t to numberOfTiers-1
	 	tierName$ = Get tier name: t
		numberOfIntervals = Get number of intervals: t
		
		numberLabeledIntervals = 0
		sumIntervalDuration = 0

		for j to numberOfIntervals
		intervalLabel$ = Get label of interval: t, j
			if intervalLabel$ <> ""
				intervalStart = Get starting point: t, j
				intervalEnd = Get end point: t, j
				intervalDuration = intervalEnd - intervalStart
				numberLabeledIntervals = numberLabeledIntervals + 1
				sumIntervalDuration = sumIntervalDuration + intervalDuration

				#Check if there is a comment in a Comments tier for any of the annotated intervals on other tiers.
				numberOfIntervalsComments = Get number of intervals: numberOfTiers
				
				comment$ = ""

				for c to numberOfIntervalsComments
					intervalCommentLabel$ = Get label of interval: numberOfTiers, c
				
					if intervalCommentLabel$ <> ""
						intervalStartComments = Get starting point: numberOfTiers, c
						intervalEndComments = Get end point: numberOfTiers, c

						if not (  (intervalEndComments < intervalStart) or (intervalStartComments > intervalEnd)  )
							comment$ = comment$ + " " + intervalCommentLabel$
						endif
					endif
				endfor
				# Write to the result file.
				fileappend "'directory$''resultfile$'.txt" 'speaker$''tab$''sex$''tab$''language$''tab$''fileName$''tab$''module$''tab$''task$''tab$''tierName$''tab$''intervalLabel$''tab$''comment$''tab$''intervalStart:3''tab$''intervalEnd:3''tab$''intervalDuration:3''newline$'
			endif
		endfor
		# Calculate speech rate, mean interval duration
		speechRate = numberLabeledIntervals / sumIntervalDuration
		meanIntervalDuration = sumIntervalDuration / numberLabeledIntervals
		# Write to the result file.
		fileappend "'directory$''resultfile$'.txt" 'speaker$''tab$''sex$''tab$''language$''tab$''fileName$''tab$''module$''tab$''task$''tab$''tierName$''tab$'e-o~f'tab$''tab$''tab$''tab$''tab$''speechRate:3''tab$''meanIntervalDuration:3''newline$'

	endfor
endfor

# Clean up the Praat objects window.
select all
Remove

###################################################################
# Split .str$ on .sep$ and store each found element in .array$ and
# length of .array$ in .length
#
# Usage:
#  include /path/to/this/script.praat
#  [code]
#  @split (SEPARATOR, STRING)
#  for i to split.length
#    str$[i] = split.array$[i]
#  endfor
#
# where SEPARATOR is a separator string and STRING is a string to
# separate.
#
# If string$ = "hello world", then after
# @split (" ", string$)
# split.array$[1] contains "hello" and split.array$[2] contains "world"
#
# Notes:
# - Since .length stores the number of items separated by a string, it is always
#   larger than the amount of occurences of that string by one, which means
#   it can be used to count occurences as well.
# - This script has been changed to use the new Praat syntax, which
#   started being introduced after v.5.3.44. It can be made to work with
#   the old syntax by replacing the definition to
#
#       procedure split .sep$ .str$
#
#   and, with the same example as above, calling it with
#
#       call split " " 'string$'
#
# Written by Jose J. Atria (28 February 2012)
# Last updated: 20 February 2014
# This script is free software: you can redistribute it and/or modify 
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# A copy of the GNU General Public License is available at
# <http://www.gnu.org/licenses/>.

procedure split (.sep$, .str$)
  .seplen = length(.sep$) 
  .length = 0
  repeat
    .strlen = length(.str$)
    .sep = index(.str$, .sep$)
    if .sep > 0
      .part$ = left$(.str$, .sep-1)
      .str$ = mid$(.str$, .sep+.seplen, .strlen)
    else
      .part$ = .str$
    endif
    .length = .length+1
    .array$[.length] = .part$
  until .sep = 0
endproc

